# Nostr

A decentralized social protocol that re-implemented the [[IETF]] RFC process as "Nostr Implementation Possibilities" (NIPs).

## In This Conversation

[[Pete Kaminski]] referenced Nostr as a modern example of the RFC process being adapted for new projects:

> **Pete:** "This has been done by geeks multiple times, but you take the RFC process that the Internet Engineering Task Force came to, and you re-implement it in a new thing, so this is Nostr."

Pete noted a design flaw — zero-padded numbers: "They actually made a mistake by zero padding these, because they're close to running out of numbers." He initially made the same mistake with IFP before [[Claude Code]] helped him see the issue.

Nostr also appears explicitly in Pete's story [[A Thousand Small Mints]], where it serves as the sync substrate for a mutual credit network — "a relay layer. Messages signed, published, replicated. Not one server. A swarm." This reflects real discussions in the Classic Ripple community about using Nostr to provide a sync layer to trust-based payment protocols (see Pete's [Architectural and social aspects of mutual credit networks](https://peterkaminski.wiki/architectural_and_social_aspects_of_mutual_credit_networks)). Pete sees Nostr not just as a standards-process model but as actual infrastructure for the kind of trust-routed, decentralized systems he's building toward with IFP.

**Mentioned by:** [[Pete Kaminski]]

## In the Inter-Face Manifesto

The [[Inter-Face Manifesto]] confirms Nostr's influence: IFP's proposal process — Inter-Face Proposals, numbered IFP-1, IFP-2, and so on — is explicitly described as "inspired by the IETF RFC process and Nostr's NIPs." Pete also notes the zero-padding lesson from NIPs: IFP numbers have no zero-padding, "no pretense of knowing how many there will be."

## Related

- [[Inter-Face Manifesto]] — confirms Nostr as a direct inspiration for IFP's proposal process
- [[Interface Protocol (IFP)]] — Pete's version of the NIP pattern
- [[IETF]] — the original model
- [[A Thousand Small Mints]] — where Nostr appears as infrastructure, not just inspiration
